/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.scripting.model.LibraryCrossReference;
import com.aptana.scripting.model.RunType;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptRunner
extends Job
implements Runnable {
    private List<String> _loadPaths;
    private RubyArray _originalLoadPaths;

    public AbstractScriptRunner(String name) {
        this(name, null);
    }

    public AbstractScriptRunner(String name, List<String> loadPaths) {
        super(name);
        this._loadPaths = loadPaths;
    }

    protected void applyLoadPaths(Ruby runtime) {
        IRubyObject object;
        if (this._loadPaths != null && this._loadPaths.size() > 0 && (object = runtime.getLoadService().getLoadPath()) instanceof RubyArray) {
            RubyArray loadPathArray = (RubyArray)object;
            this._originalLoadPaths = (RubyArray)loadPathArray.dup();
            for (String loadPath : this._loadPaths) {
                RubyString toAdd = runtime.newString(loadPath.replace('\\', '/'));
                loadPathArray.append((IRubyObject)toAdd);
            }
        }
    }

    protected void registerLibraries(Ruby runtime, String filename) {
        if (this._loadPaths != null && this._loadPaths.size() > 0) {
            LinkedList<File> paths = new LinkedList<File>();
            for (String loadPath : this._loadPaths) {
                File path = new File(loadPath);
                if (!path.isDirectory() || !path.getName().equals("lib")) continue;
                paths.add(path);
            }
            if (paths.size() > 0) {
                IRubyObject object = runtime.getLoadService().getLoadedFeatures();
                LibraryCrossReference xref = LibraryCrossReference.getInstance();
                if (object instanceof RubyArray) {
                    RubyArray loadedFeaturesArray = (RubyArray)object;
                    block1: for (Object featureObject : loadedFeaturesArray) {
                        if (!(featureObject instanceof String)) continue;
                        String feature = (String)featureObject;
                        if (File.separatorChar == '\\') {
                            feature = feature.replace('/', '\\');
                        }
                        for (File path : paths) {
                            File lib = new File(path, feature);
                            if (!lib.isFile()) continue;
                            xref.registerLibraryReference(filename, lib.getAbsolutePath());
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void run() {
        this.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void run(String name, RunType runType, boolean async) throws InterruptedException {
        switch (runType) {
            case JOB: {
                this.setPriority(async ? 20 : 10);
                this.schedule();
                if (async) break;
                this.join();
                break;
            }
            case THREAD: {
                Thread thread = new Thread((Runnable)this, name);
                thread.start();
                if (async) break;
                thread.join();
                break;
            }
            default: {
                this.run();
            }
        }
    }

    protected void unapplyLoadPaths(Ruby runtime) {
        IRubyObject object;
        if (this._loadPaths != null && this._loadPaths.size() > 0 && (object = runtime.getLoadService().getLoadPath()) != null && object instanceof RubyArray) {
            RubyArray loadPathArray = (RubyArray)object;
            loadPathArray.replace((IRubyObject)this._originalLoadPaths);
            this._originalLoadPaths = null;
        }
    }
}

